/*
 * Decompiled with CFR 0.152.
 */
package me.angel.challenges6t4.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import me.angel.challenges6t4.challenge.Challenge;
import me.angel.challenges6t4.challenge.ChallengeRegistry;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_7157;

public class ChallengeCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess, class_2170.class_5364 environment) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"challenge").requires(source -> source.method_9259(2))).then(class_2170.method_9247((String)"list").executes(context -> {
            class_2168 source = (class_2168)context.getSource();
            source.method_45068((class_2561)class_2561.method_43470((String)"Available challenges:"));
            for (Challenge challenge : ChallengeRegistry.getAllChallenges()) {
                String status = challenge.isEnabled() ? "\u00a7aENABLED" : "\u00a7cDISABLED";
                source.method_45068((class_2561)class_2561.method_43470((String)("  " + challenge.getId() + " - " + status)));
            }
            return 1;
        }))).then(class_2170.method_9247((String)"enable").then(class_2170.method_9244((String)"challenge", (ArgumentType)StringArgumentType.string()).executes(context -> {
            String challengeId = StringArgumentType.getString((CommandContext)context, (String)"challenge");
            Challenge challenge = ChallengeRegistry.getChallenge(challengeId);
            if (challenge != null) {
                challenge.setEnabled(true);
                ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)("\u00a7aEnabled challenge: " + challengeId)));
                if (((class_2168)context.getSource()).method_44023() != null) {
                    ChallengeRegistry.syncToAllClientsFromServer(((class_2168)context.getSource()).method_44023());
                }
            } else {
                ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)("\u00a7cChallenge not found: " + challengeId)));
            }
            return 1;
        })))).then(class_2170.method_9247((String)"disable").then(class_2170.method_9244((String)"challenge", (ArgumentType)StringArgumentType.string()).executes(context -> {
            String challengeId = StringArgumentType.getString((CommandContext)context, (String)"challenge");
            Challenge challenge = ChallengeRegistry.getChallenge(challengeId);
            if (challenge != null) {
                challenge.setEnabled(false);
                ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)("\u00a7cDisabled challenge: " + challengeId)));
                if (((class_2168)context.getSource()).method_44023() != null) {
                    ChallengeRegistry.syncToAllClientsFromServer(((class_2168)context.getSource()).method_44023());
                }
            } else {
                ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)("\u00a7cChallenge not found: " + challengeId)));
            }
            return 1;
        })))).then(class_2170.method_9247((String)"toggle").then(class_2170.method_9244((String)"challenge", (ArgumentType)StringArgumentType.string()).executes(context -> {
            String challengeId = StringArgumentType.getString((CommandContext)context, (String)"challenge");
            Challenge challenge = ChallengeRegistry.getChallenge(challengeId);
            if (challenge != null) {
                boolean newState = !challenge.isEnabled();
                challenge.setEnabled(newState);
                String status = newState ? "\u00a7aENABLED" : "\u00a7cDISABLED";
                ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)("\u00a7eToggled challenge " + challengeId + " to " + status)));
                if (((class_2168)context.getSource()).method_44023() != null) {
                    ChallengeRegistry.syncToAllClientsFromServer(((class_2168)context.getSource()).method_44023());
                }
            } else {
                ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)("\u00a7cChallenge not found: " + challengeId)));
            }
            return 1;
        })))).then(class_2170.method_9247((String)"status").then(class_2170.method_9244((String)"challenge", (ArgumentType)StringArgumentType.string()).executes(context -> {
            String challengeId = StringArgumentType.getString((CommandContext)context, (String)"challenge");
            Challenge challenge = ChallengeRegistry.getChallenge(challengeId);
            if (challenge != null) {
                String status = challenge.isEnabled() ? "\u00a7aENABLED" : "\u00a7cDISABLED";
                ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)("Challenge " + challengeId + " is " + status)));
            } else {
                ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)("\u00a7cChallenge not found: " + challengeId)));
            }
            return 1;
        }))));
    }
}

